#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_call32_I32imm(int seg,Bit8u* imm)
{
Bit32u new_EIP;
Bit32u arg0;
Bit32u immdat;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
immdat|=(*(imm+0+2))<<16;
immdat|=(*(imm+0+3))<<24;
#else
immdat=*((Bit32u*)(imm+0));
#endif


arg0=immdat;

#if BX_DEBUGGER
BX_CPU_THIS_PTR show_flag |= Flag_call;
#endif
invalidate_prefetch_q();
new_EIP = EIP + arg0;
if ( protected_mode() ) {
  if ( new_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled ) {
    BX_PANIC(("call_av: offset outside of CS limits\n"));
    exception(BX_GP_EXCEPTION, 0, 0);
  }
}
/* push 32 bit EA of next instruction */
push_32(BX_CPU_THIS_PTR eip);
BX_CPU_THIS_PTR eip = new_EIP;
BX_INSTR_UCNEAR_BRANCH(BX_INSTR_IS_CALL, BX_CPU_THIS_PTR eip);
}
